# unicode_file
# Copyright 2010-2011 Karl A. Knechtel.
#
# A simple wrapper which handles all common Unicode encodings for text files.
#
# Licensed under the Generic Non-Commercial Copyleft Software License,
# Version 1.1 (hereafter "Licence"). You may not use this file except
# in the ways outlined in the Licence, which you should have received
# along with this file.
#
# Unless required by applicable law or agreed to in writing, software 
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied. See the License for the specific language governing
# permissions and limitations under the License.


import codecs

class unicode_file(object):
	__slots__ = ['_stream']


	def __init__(self, filename): self._stream = file(filename, 'rb')


	def __enter__(self):
		# Check for a UTF-16 BOM. If none is found, assume a UTF-8 file
		# that may or may not start with a UTF-8 BOM.
		header = self._stream.read(2)
		if header == codecs.BOM_LE: codec = 'utf-16-le'
		elif header == codecs.BOM_BE: codec = 'utf-16-be'
		else: self._stream.seek(0); codec = 'utf-8-sig'
		return codecs.getreader(codec)(self._stream)


	def __exit__(self, exc_type, value, traceback): self._stream.close()
